/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.placement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.utils.presets.PresettedObject;
import ivorius.reccomplex.utils.presets.PresettedObjects;
import ivorius.reccomplex.world.gen.feature.structure.Placer;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.FactorLimit;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.GenericPlacer;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.rays.RayDynamicPosition;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.rays.RayMatcher;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.rays.RayMove;
import ivorius.reccomplex.world.gen.feature.structure.generic.presets.GenericPlacerPresets;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class SelectivePlacer
implements Placer {
    public static Gson gson = SelectivePlacer.createGson();
    public final PresettedObject<GenericPlacer> placer = new PresettedObject<GenericPlacer>(GenericPlacerPresets.instance(), null);
    public int baseline;
    public BlockExpression sourceMatcher;

    public SelectivePlacer() {
        this.placer.setPreset("surface");
        this.baseline = 0;
        this.sourceMatcher = ExpressionCache.of(new BlockExpression(RecurrentComplex.specialRegistry), "!(air | reccomplex:generic_space)");
    }

    public SelectivePlacer(GenericPlacer placer, int baseline) {
        this.placer.setContents(placer);
        this.baseline = baseline;
        this.sourceMatcher = ExpressionCache.of(new BlockExpression(RecurrentComplex.specialRegistry), "");
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(SelectivePlacer.class, (Object)new Serializer());
        builder.registerTypeAdapter(GenericPlacer.class, (Object)new GenericPlacer.Serializer());
        return builder.create();
    }

    @Nonnull
    public static SelectivePlacer surfacePlacer(int baseline) {
        SelectivePlacer surface = new SelectivePlacer();
        surface.placer.setPreset("surface");
        surface.baseline = baseline;
        return surface;
    }

    @Nonnull
    public static SelectivePlacer underwaterPlacer(int baseline) {
        SelectivePlacer surface = new SelectivePlacer();
        surface.placer.setPreset("underwater");
        surface.baseline = baseline;
        return surface;
    }

    @Override
    public int place(StructurePlaceContext context, IvBlockCollection blockCollection) {
        Set<BlockPos> surface = BlockAreas.side((BlockArea)blockCollection.area(), (EnumFacing)EnumFacing.DOWN).stream().map(p -> BlockSurfacePos.from((BlockPos)p).blockPos(this.baseline)).filter(p -> (Boolean)this.sourceMatcher.evaluate(blockCollection.getBlockState(p))).collect(Collectors.toSet());
        return this.placer.getContents().place(context, blockCollection, surface);
    }

    public static class Serializer
    implements JsonSerializer<SelectivePlacer>,
    JsonDeserializer<SelectivePlacer> {
        @Nonnull
        public static SelectivePlacer readLegacyPlacer(JsonDeserializationContext context, JsonObject jsonObject) {
            SelectivePlacer placer;
            GenericPlacer.Serializer.SelectionMode selectionMode = jsonObject.has("selectionMode") ? (GenericPlacer.Serializer.SelectionMode)((Object)context.deserialize(jsonObject.get("selectionMode"), GenericPlacer.Serializer.SelectionMode.class)) : GenericPlacer.Serializer.SelectionMode.SURFACE;
            int minYShift = JsonUtils.getInt(jsonObject, "minY", 0);
            int maxYShift = JsonUtils.getInt(jsonObject, "maxY", 0);
            RayDynamicPosition.Type dynType = null;
            switch (selectionMode) {
                default: {
                    placer = SelectivePlacer.surfacePlacer(-(minYShift + maxYShift) / 2);
                    break;
                }
                case UNDERWATER: {
                    placer = SelectivePlacer.underwaterPlacer(-(minYShift + maxYShift) / 2);
                    break;
                }
                case LOWEST_EDGE: {
                    placer = new SelectivePlacer(new GenericPlacer(Collections.singletonList(new FactorLimit(1.0f, Arrays.asList(new RayDynamicPosition(null, RayDynamicPosition.Type.WORLD_HEIGHT), new RayMatcher(null, false, 0.9f, "!(is:air | is:foliage | is:replaceable) & !is:liquid"), new RayMove(null, minYShift), new RayMove(Float.valueOf(1.0f), maxYShift - minYShift))))), 0);
                    break;
                }
                case BEDROCK: {
                    dynType = RayDynamicPosition.Type.BEDROCK;
                }
                case SEALEVEL: {
                    if (dynType == null) {
                        dynType = RayDynamicPosition.Type.SEALEVEL;
                    }
                }
                case TOP: {
                    if (dynType == null) {
                        dynType = RayDynamicPosition.Type.WORLD_HEIGHT;
                    }
                    placer = new SelectivePlacer(new GenericPlacer(Collections.singletonList(new FactorLimit(1.0f, Arrays.asList(new RayDynamicPosition(null, dynType), new RayMove(null, minYShift), new RayMove(Float.valueOf(1.0f), maxYShift - minYShift))))), 0);
                }
            }
            return placer;
        }

        public SelectivePlacer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            SelectivePlacer selectivePlacer = new SelectivePlacer();
            JsonObject jsonObject = json.getAsJsonObject();
            if (!PresettedObjects.read(jsonObject, gson, selectivePlacer.placer, "placerPreset", "placer", new TypeToken<GenericPlacer>(){}.getType()) && jsonObject.has("generationY")) {
                return Serializer.readLegacyPlacer(context, JsonUtils.getJsonObject(jsonObject, "generationY", new JsonObject()));
            }
            selectivePlacer.baseline = JsonUtils.getInt(jsonObject, "baseline", 0);
            selectivePlacer.sourceMatcher.setExpression(JsonUtils.getString(jsonObject, "sourceExpression", ""));
            return selectivePlacer;
        }

        public JsonElement serialize(SelectivePlacer src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            PresettedObjects.write(jsonObject, gson, src.placer, "placerPreset", "placer");
            jsonObject.addProperty("baseline", (Number)src.baseline);
            jsonObject.addProperty("sourceExpression", src.sourceMatcher.getExpression());
            return jsonObject;
        }
    }
}

